package org.msh.utils;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Created by rmemoria on 12/9/17.
 */
public class AllowFromFilter implements Filter {
    @Override
    public void init(FilterConfig filterConfig) throws ServletException {

    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest r = (HttpServletRequest)request;
        String path = r.getServletPath();

        // Inform the browser that page should not be stored in cache
        if (path.endsWith("dashboard.seam")) {
            StringBuffer url = r.getRequestURL();
            String host = url.substring(0, url.indexOf(r.getRequestURI()));
            ((HttpServletResponse)response).setHeader("X-Frame-Options","ALLOW-FROM " + host);
        }

        filterChain.doFilter(request, response);
    }

    @Override
    public void destroy() {

    }
}
